﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SzkoleniaLista.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.SzkoleniaLista" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Szkolenia</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/i18n/jquery.ui.datepicker-pl.js" type="text/javascript"></script>
    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $('#tbDataOd').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
            $('#tbDataDo').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });

            $("#tbDataOd").datepicker("option", "dateFormat", 'yy-mm-dd');
            $("#tbDataDo").datepicker("option", "dateFormat", 'yy-mm-dd');

            $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
            $(".btnPotwierdzGrid").button({ icons: { primary: 'ui-icon-check' } });
            $(".btnWydrukGrid").button({ icons: { primary: 'ui-icon-print' } });


            //$("#dialog-form").dialog({
            //    autoOpen: false,
            //    width: 400,
            //    modal: true,
            //    position: "top",
            //    resizable: false

            //});
        });
    </script>
    <style>
        .kolumnSzkolenie{
            min-width:200px;
        }

        .kolumnData{
            min-width:85px;
        }
    </style>
</head>
<body id="body" style="font-size: 8pt;" runat="server">
    <form id="form1" runat="server">
        <div>
            <asp:Label ID="lblError" runat="server" EnableViewState="false"></asp:Label>
            <asp:Label ID="lblKomunikat" runat="server" EnableViewState="true"></asp:Label>
            <table class="bodyLRT0" cellspacing="0" cellpadding="0" width="100%" border="0">
                <tr>
                    <td colspan="5">
                        <asp:Label ID="lblNaglowek" runat="server" Style="font-size: 12pt; font-weight: bold">Szkolenia</asp:Label>
                    </td>
                </tr>
                <tr>
                    <td valign="bottom">
                        <small>
                            <asp:Label ID="lblNazwisko" runat="server">Nazwisko</asp:Label></small><br />
                        <asp:TextBox ID="tbNazwisko" Width="95%" runat="server"></asp:TextBox>
                    </td>
                    <td colspan="2" valign="bottom">
                        <small>
                            <asp:Label ID="lblImie" runat="server">Imię</asp:Label></small><br />
                        <asp:TextBox ID="tbImie" Width="100%" runat="server"></asp:TextBox>
                    </td>
                    <td colspan="1" style="text-align: right" valign="bottom">
                        <%--<a id="btnRaport" runat="server" style="width: 90px;" class="aspButton" href="javascript:OtworzOkienkoRaportu();" visible="False">Obiegówki przetermin.</a>--%>
                    </td>
                </tr>
                <tr>
                    <td style="width: 40%" valign="bottom">
                        <small>Jednostka</small><br />
                        <asp:DropDownList ID="ddlJednostka" runat="server" Width="95%"></asp:DropDownList>
                    </td>
                    <td style="width: 30%" valign="bottom">
                        <small>Status</small><br />
                        <asp:DropDownList ID="ddlStatus" Width="100%" runat="server">
                            <asp:ListItem Value="0">-Wybierz status-</asp:ListItem>
                            <asp:ListItem Value="NRO">Nierozpoczęte</asp:ListItem>
                            <asp:ListItem Value="RO">Rozpoczęte</asp:ListItem>
                            <asp:ListItem Selected="True" Value="NZAK">Niezakończone</asp:ListItem>
                            <asp:ListItem Value="SZK">Odbyte</asp:ListItem>
                            <asp:ListItem Value="ZAK">Wydrukowane oświadczenie (zakończone)</asp:ListItem>
                            <asp:ListItem Value="ANU">Anulowany</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td style="width: 15%" valign="bottom">
                        <small>&nbsp;</small><br />
                        <asp:CheckBox ID="cbTylkoWlasne" runat="server" Text="Tylko własne" Checked="true" ></asp:CheckBox>
                    </td>
                    <td style="width: 15%; text-align: right" valign="bottom">
                        <small></small>
                        <br />
                        <asp:LinkButton ID="btnOdswiez" runat="server" Text="Odśwież" Width="90px" CssClass="aspButton" OnClick="btnOdswiez_Click"></asp:LinkButton>
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
                <div style="float: left; position: absolute; bottom: 2px;">
                    <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
                </div>
            </div>
            <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_SZKOLENIA,ID_PRACOWNIKA,ID_UMOWY,ID_UMOWY_SZKOLENIA,ID_SZKOLENIA_SLOWNIK,STATUS,IMIE,NAZWISKO,JEDNOSTKA,STANOWISKO,DATA_OD,DATA_DO,STATUS_NAZWA,PRAWO_SZKOLENIE,PRAWO_POTWIERDZENIE,PRAWO_WYDRUK,DATA_OSWIADCZENIA,BHP" AllowPaging="True" OnRowCommand="gvListy_RowCommand" OnRowDataBound="gvListy_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="Szkolenie">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbOtworzGrid" runat="server" CausesValidation="false" CommandName="OTWORZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Otwórz" style="font-size:9pt; color:blue;"></asp:LinkButton>
                            <asp:Label ID="lblSzkolenie" runat="server" style="font-size:9pt;"></asp:Label>
                        </ItemTemplate>
                        <ItemStyle VerticalAlign="Middle" CssClass="kolumnSzkolenie" />
                    </asp:TemplateField>
                    <asp:TemplateField ShowHeader="False">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbPotwierdzGrid" class="btnPotwierdzGrid" runat="server" CausesValidation="false" CommandName="POTWIERDZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Potwierdź szkolenie"></asp:LinkButton>
                            <asp:LinkButton ID="lbWydrukGrid" class="btnWydrukGrid" runat="server" CausesValidation="false" CommandName="WYDRUK" CommandArgument='<%# Container.DataItemIndex %>' Text="Pobierz oświadczenie"></asp:LinkButton>
                        </ItemTemplate>
                        <ItemStyle VerticalAlign="Middle" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="NAZWISKO" HeaderText="Nazwisko" SortExpression="NAZWISKO" />
                    <asp:BoundField DataField="IMIE" HeaderText="Imię" SortExpression="IMIE" />
                    <asp:BoundField DataField="ID_KONTRAHENTA" HeaderText="Id kontrahenta(CSK)" SortExpression="ID_KONTRAHENTA" />
                    <asp:BoundField DataField="JEDNOSTKA" HeaderText="Jednostka" SortExpression="JEDNOSTKA" />
                    <asp:BoundField DataField="STANOWISKO" HeaderText="Stanowisko" SortExpression="STANOWISKO" />
                    <asp:BoundField DataField="UMOWA_OD" HeaderText="Do umowy od" DataFormatString="{0:yyyy-MM-dd}" SortExpression="UMOWA_OD" >
                    <HeaderStyle Width="85px" CssClass="kolumnData" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="Obowiązuje od" SortExpression="DATA_OD">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("DATA_OD") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="Label1" runat="server" Text='<%# Bind("DATA_OD", "{0:yyyy-MM-dd}") %>'></asp:Label>
                        </ItemTemplate>
                        <ControlStyle Width="65px" />
                        <HeaderStyle Width="65px" />
                        <ItemStyle Width="65px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Obowiązuje do" SortExpression="DATA_DO">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox2" runat="server" Text='<%# Bind("DATA_DO") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="Label2" runat="server" Text='<%# Bind("DATA_DO", "{0:yyyy-MM-dd}") %>'></asp:Label>
                        </ItemTemplate>
                        <ControlStyle Width="65px" />
                        <HeaderStyle Width="65px" />
                        <ItemStyle Width="65px" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="STATUS_NAZWA" HeaderText="Status" SortExpression="STATUS_NAZWA" />
                    <asp:BoundField DataField="DATA_UTWORZENIA" HeaderText="Data utworzenia" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_UTWORZENIA" >
                    <HeaderStyle Width="85px" CssClass="kolumnData" />
                    </asp:BoundField>
                    <asp:BoundField DataField="DATA_ROZPOCZECIA_SZKOLENIA" HeaderText="Data rozpoczęcia" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ROZPOCZECIA_SZKOLENIA" >
                    <HeaderStyle Width="85px" CssClass="kolumnData" />
                    </asp:BoundField>
                    <asp:BoundField DataField="DATA_SZKOLENIA" HeaderText="Data szkolenia" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_SZKOLENIA" >
                    <HeaderStyle Width="85px" CssClass="kolumnData" />
                    </asp:BoundField>
                    <asp:BoundField DataField="DATA_OSWIADCZENIA" HeaderText="Data wydruku" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_OSWIADCZENIA" >
                    <HeaderStyle Width="85px" CssClass="kolumnData" />
                    </asp:BoundField>
                    <asp:BoundField DataField="DATA_ANULOWANIA" HeaderText="Data anulowania" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ANULOWANIA" >
                    <HeaderStyle Width="85px" CssClass="kolumnData" />
                    </asp:BoundField>
                    <asp:BoundField DataField="ANULUJACY" HeaderText="Anulujący" SortExpression="ANULUJACY" />
                </Columns>
                <PagerSettings Position="Top" />
                <RowStyle CssClass="TableItem" />
                <SelectedRowStyle CssClass="TableItemSelected" />
                <HeaderStyle CssClass="TableHeader" />
                <AlternatingRowStyle CssClass="TableItemAlt" />
            </asp:GridView>
            <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="SZKOLENIA_PRACOWNICY_LIST" SelectCommandType="StoredProcedure" ConnectionString="" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected" OnSelecting="sdsListy_Selecting">
                <SelectParameters>
                    <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                    <asp:ControlParameter ControlID="tbNazwisko" Name="P_NAZWISKO" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    <asp:ControlParameter ControlID="tbImie" Name="P_IMIE" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    <asp:ControlParameter ControlID="ddlStatus" Name="P_STATUS" PropertyName="SelectedValue" Type="String" />
                    <asp:ControlParameter ControlID="ddlJednostka" Name="P_ID_MPZ" PropertyName="SelectedValue" />
                    <asp:Parameter Name="P_ID_PRACOWNIKA" />
                </SelectParameters>
            </asp:SqlDataSource>
        </div>
        <!-- Okienko dialogu -->
        <%--        <div id="dialog-form" title="Obiegówki przeterminowane, nie zatwierdzone">
            <div style="width: 100%;">
                <small>Jednostka</small><br />
                <asp:DropDownList ID="ddlJednostkiRaport" runat="server" Width="100%">
                </asp:DropDownList><br />
                <small>Od (rrrr-mm-dd)</small><br />
                <asp:TextBox ID="tbDataOdRaport" runat="server"></asp:TextBox><br />
                <small>Do (rrrr-mm-dd)</small><br />
                <asp:TextBox ID="tbDataDoRaport" runat="server"></asp:TextBox><br />
                <asp:CheckBox ID="cbPrzeterminowane" runat="server" Checked="True" Text="Przeterminowane" />
            </div>
            <div style="height: 5px;">
                &nbsp;
            </div>
            <div>
                <div style="float: right;">
                    <asp:LinkButton ID="btnRaportWybierz" runat="server" Text="Wybierz" OnClick="btnRaportWybierz_Click" />
                    <a id="btnRaportAnuluj" href="javascript:ZamknijOkienkoRaportu()">Anuluj</a>
                </div>
            </div>
        </div>--%>
        <iframe id="Panel" name="Panel" src="SzkoleniaOswiadczeniaWydrukPdf.aspx" frameborder="0" runat="server"></iframe>
    </form>
</body>
</html>

